/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.monitor;

import com.ibm.hwmca.base.monitor.MonitorCondition;
import com.ibm.hwmca.base.monitor.MonitorConditionResult;
import com.ibm.hwmca.base.monitor.MonitorUtils;
import com.ibm.hwmca.base.monitor.ObjectWrapper;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Properties;

public class MonitorThreads
implements MonitorCondition {
    private static final String TRACE_MASKD = "XMONMNTD";
    private static final String TRACE_MASKF = "XMONMNTF";
    private static final String TRACE_MASKT = "XMONMNTT";
    private static final String THRESHOLD_KEY_WORD = "threshold";
    private static final String PROGRAM_KEY_WORD = "program";
    private int threshold = Integer.MAX_VALUE;
    private String program = null;

    public static void main(String[] args) {
    }

    public void init(String arg) throws HException {
        Properties properties = null;
        String value = null;
        Trace.trace(TRACE_MASKT, "-> init(" + arg + ")");
        if (arg != null && arg.length() > 0) {
            properties = MonitorUtils.createProperties(arg);
            value = (String)properties.get(THRESHOLD_KEY_WORD);
            if (value == null) {
                throw new HException("No threshold specified in argument.");
            }
            this.threshold = Integer.parseInt(value);
            this.program = (String)properties.get(PROGRAM_KEY_WORD);
            if (this.program == null) {
                throw new HException("No program specified in argument.");
            }
        }
        Trace.trace(TRACE_MASKT, "<- init(...)");
    }

    public MonitorConditionResult checkCondition(ObjectWrapper token) {
        MonitorConditionResult result = null;
        Object command = null;
        Integer numOfThreads = null;
        boolean exitRC = false;
        Object stdOut = null;
        Trace.trace(TRACE_MASKT, "-> conditionTrue(" + token + ")");
        result = new MonitorConditionResult(false);
        numOfThreads = this.getNumOfThreads();
        if (numOfThreads != null && numOfThreads >= this.threshold) {
            result = new MonitorConditionResult(true);
        }
        Trace.trace(TRACE_MASKT, "<- conditionTrue(...) returning " + result + " and wrapped object of " + token.getObject());
        return result;
    }

    public void terminate() {
        Trace.trace(TRACE_MASKT, "-> terminate()");
        Trace.trace(TRACE_MASKT, "<- terminate()");
    }

    private Integer getParentPID(String stdOut) {
        Integer result = null;
        String pIDAsString = null;
        Trace.trace(TRACE_MASKT, "-> getParentPID(" + stdOut + ")");
        pIDAsString = MonitorUtils.getWordX(stdOut, 3);
        if (pIDAsString != null) {
            try {
                result = new Integer(pIDAsString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        Trace.trace(TRACE_MASKT, "-> getParentPID(...) returning " + result);
        return result;
    }

    private Integer getPID(String stdOut) {
        Integer result = null;
        int pID = 0;
        String pIDAsString = null;
        Trace.trace(TRACE_MASKT, "-> getPID(" + stdOut + ")");
        pIDAsString = MonitorUtils.getWordX(stdOut, 2);
        if (pIDAsString != null) {
            try {
                pID = Integer.parseInt(pIDAsString);
                result = new Integer(pID);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        Trace.trace(TRACE_MASKT, "-> getPID(...) returning " + result);
        return result;
    }

    private Integer getNumOfThreads() {
        Integer result = null;
        String[] command = null;
        ObjectWrapper stdOut = null;
        int exitRC = 0;
        Trace.trace(TRACE_MASKT, "-> getNumOfThreads()");
        command = new String[]{"/bin/bash", "-c", "ps -Afww | grep " + this.program + " | wc -l"};
        stdOut = new ObjectWrapper();
        exitRC = MonitorUtils.execute(command, stdOut, null);
        if (exitRC == 0 && stdOut.getObject() != null) {
            try {
                result = new Integer(Integer.parseInt(((String)stdOut.getObject()).trim()) - 1);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        Trace.trace(TRACE_MASKT, "<- getNumOfThreads() returning " + result);
        return result;
    }
}

